/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FireBreathEntity
extends AbstractHurtingProjectile {
    private int removeTicker;

    public FireBreathEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level world) {
        super(entityType, world);
    }

    @Environment(value=EnvType.CLIENT)
    public FireBreathEntity(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.FIRE_BREATH, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20334_(velocityX, velocityY, velocityZ);
    }

    public FireBreathEntity(Level world, LivingEntity owner, double velocityX, double velocityY, double velocityZ) {
        super(EntityInit.FIRE_BREATH, owner, velocityX, velocityY, velocityZ, world);
        Vec3 newVec3d = this.m_20184_().m_82541_().m_82520_(this.f_19796_.m_188583_() * 0.1, -this.f_19796_.m_188500_() * 0.1, this.f_19796_.m_188583_() * 0.1);
        this.m_20256_(newVec3d);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected ParticleOptions m_5967_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());
    }

    protected float m_6884_() {
        return 0.9f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                double d = this.m_9236_().m_213780_().m_188583_() * 0.01;
                double e = this.m_9236_().m_213780_().m_188583_() * 0.01;
                double f = this.m_9236_().m_213780_().m_188583_() * 0.01;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, e, f);
            }
        } else {
            ++this.removeTicker;
            if (this.removeTicker >= 80) {
                this.m_146870_();
            }
        }
    }

    public boolean m_6060_() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = this.m_19749_();
        Entity hittedEntity = entityHitResult.m_82443_();
        if (!this.m_9236_().m_5776_() && entity != null && hittedEntity instanceof LivingEntity) {
            hittedEntity.m_20254_(8);
            hittedEntity.m_6469_(this.createDamageSource((Entity)this), 3.0f);
            this.m_146870_();
        }
    }

    private DamageSource createDamageSource(Entity entity) {
        return entity.m_269291_().m_269298_(EntityInit.FIRE_BREATH_KEY, entity);
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            Entity entity = this.m_19749_();
            if (entity == null || !(entity instanceof Mob) || this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                BlockPos blockPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                if (this.m_9236_().m_46859_(blockPos)) {
                    this.m_9236_().m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockPos));
                }
            }
            this.m_146870_();
        }
    }
}

